﻿using System;

using RimWorld;
using UnityEngine;
using HarmonyLib;
using Verse;
using System.Reflection;
using Verse.AI;


namespace betterJumpPack
{
    // 도착지점 강제 제한
    [HarmonyPatch(typeof(Verb_Jump), "OrderForceTarget")]
    public static class patch_Verb_Jump_OrderForceTarget
    {
        [HarmonyPostfix]
        static bool Prefix(Verb_Jump __instance, LocalTargetInfo target)
        {
            Map map = __instance.CasterPawn.Map;
            IntVec3 cell = betterJumpPack.BestOrderedGotoDestNear_NewTemp(target.Cell, __instance.CasterPawn, new Predicate<IntVec3>(AcceptableDestination));
            Job job = JobMaker.MakeJob(JobDefOf.CastJump, (LocalTargetInfo)cell);
            job.verbToUse = (Verb)__instance;
            if (!__instance.CasterPawn.jobs.TryTakeOrderedJob(job))
                return false;
            MoteMaker.MakeStaticMote(cell, map, ThingDefOf.Mote_FeedbackGoto);

            bool AcceptableDestination(IntVec3 c) => __instance.CanHitTargetFrom(__instance.caster.Position, (LocalTargetInfo)c);
            return false;
        }
    }


    // 출발 시
    [HarmonyPatch(typeof(PawnFlyer), "MakeFlyer")]
    public static class patch_PawnFlyer_MakeFlyer
    {
        private static MethodInfo a_ValidateFlyer = AccessTools.Method(typeof(PawnFlyer), "ValidateFlyer");
        

        [HarmonyPostfix]
        static bool Prefix(ref PawnFlyer __result, PawnFlyer __instance, ThingDef flyingDef, Pawn pawn, IntVec3 destCell)
        {
            PawnFlyer tmp_pawnFlyer = (PawnFlyer)ThingMaker.MakeThing(flyingDef);
            
            if (!((bool)AccessTools.Method(typeof(PawnFlyer), "ValidateFlyer").Invoke(tmp_pawnFlyer, null)))
            {
                __result = (PawnFlyer)null;
                return false;
            }
            if (destCell.Fogged(pawn.Map))
            {
                FloodFillerFog.FloodUnfog(destCell, pawn.Map);
            }

            // 출발시 지붕 파괴
            if (pawn.Position.Roofed(pawn.Map))
            {
                RoofCollapserImmediate.DropRoofInCells(pawn.Position, pawn.Map);
                if (pawn.Dead) return false;
            }

            Traverse.Create(tmp_pawnFlyer).Field("startVec").SetValue(pawn.TrueCenter());
            Traverse.Create(tmp_pawnFlyer).Field("flightDistance").SetValue(pawn.Position.DistanceTo(destCell));
            Traverse.Create(tmp_pawnFlyer).Field("pawnWasDrafted").SetValue(pawn.Drafted);
            Traverse.Create(tmp_pawnFlyer).Field("pawnWasSelected").SetValue(Find.Selector.IsSelected((object)pawn));
            
            if (Traverse.Create(tmp_pawnFlyer).Field("pawnWasDrafted").GetValue<bool>())
                Find.Selector.ShelveSelected((object)pawn);

            Traverse.Create(tmp_pawnFlyer).Field("jobQueue").SetValue(pawn.jobs.CaptureAndClearJobQueue());
            pawn.DeSpawn(DestroyMode.Vanish);
            if (!Traverse.Create(tmp_pawnFlyer).Field("innerContainer").GetValue<ThingOwner<Thing>>().TryAdd((Thing)pawn, true))
            {
                Log.Error("Could not add " + pawn.ToStringSafe<Pawn>() + " to a flyer.");
                pawn.Destroy(DestroyMode.Vanish);
            }
            __result = tmp_pawnFlyer;

            

            return false;
        }
    }


    // 도착 시
    [HarmonyPatch(typeof(PawnJumper), "LandingEffects")]
    public static class patch_PawnJumper_LandingEffects
    {
        [HarmonyPostfix]
        static bool Prefix(PawnJumper __instance)
        {
            IntVec3 c = __instance.DestinationPos.ToIntVec3();
            
            Map m = __instance.Map;
            if (c.Roofed(m))
            {
                RoofCollapserImmediate.DropRoofInCells(c, m);
            }

            
            return true;
        }
    }


    // 도착지점 선택 가능여부
    [HarmonyPatch(typeof(Verb_Jump), "CanHitTargetFrom")]
    public static class patch_Verb_Jump_CanHitTargetFrom
    {
        [HarmonyPostfix]
        static bool Prefix(ref bool __result, Verb_Jump __instance, IntVec3 root, LocalTargetInfo targ)
        {
            float EffectiveRange = __instance.EquipmentSource.GetStatValue(StatDefOf.JumpRange);
            float num = EffectiveRange * EffectiveRange;
            Map m = __instance.CasterPawn.Map;
            IntVec3 cell = targ.Cell;

            if(!root.Roofed(m) || (!root.GetRoof(m).isThickRoof && !root.GetRoof(m).isNatural))
            {
                __result = (double)__instance.caster.Position.DistanceToSquared(cell) <= (double)num && (!cell.Roofed(m) || (!cell.GetRoof(m).isThickRoof && !cell.GetRoof(m).isNatural));
            }
            else
            {
                __result = false;
            }
            

            return false;
        }
    }


    // 기즈모 표시
    [HarmonyPatch(typeof(Verb_Jump), "DrawHighlight")]
    public static class patch_Verb_Jump_DrawHighlight
    {
        [HarmonyPostfix]
        static bool Prefix(Verb_Jump __instance, LocalTargetInfo target)
        {
            float EffectiveRange = __instance.EquipmentSource.GetStatValue(StatDefOf.JumpRange);
            
            Thing t = __instance.caster;
            Map m = t.Map;
            IntVec3 cell = t.Position;
            bool canJump = !cell.Roofed(m) || (!cell.GetRoof(m).isThickRoof && !cell.GetRoof(m).isNatural);

            if (target.IsValid && Verb_Jump.ValidJumpTarget(__instance.caster.Map, target.Cell))
                GenDraw.DrawTargetHighlightWithLayer(target.CenterVector3, AltitudeLayer.MetaOverlays);
            GenDraw.DrawRadiusRing(__instance.caster.Position, EffectiveRange, Color.white
                , (Func<IntVec3, bool>)(c => canJump && Verb_Jump.ValidJumpTarget(__instance.caster.Map, c)));

            return false;
        }
    }


    
    [HarmonyPatch(typeof(Verb_Jump), "ValidJumpTarget")]
    public static class patch_Verb_Jump_ValidJumpTarget
    {
        [HarmonyPostfix]
        static bool Prefix(ref bool __result, Verb_Jump __instance, Map map, IntVec3 cell)
        {
            //if (!cell.IsValid || !cell.InBounds(map) || (cell.Impassable(map) || !cell.Walkable(map)) || cell.Fogged(map))
            if (!cell.InBounds(map) || (cell.Impassable(map) || !cell.Walkable(map)))
            {
                __result = false;
                return false;
            }
            
            Building edifice = cell.GetEdifice(map);
            __result = edifice == null || !(edifice is Building_Door buildingDoor) || buildingDoor.Open;
            return false;
        }
    }



}